﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Web.Configuration;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using System.Reflection;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class AHOBPRGlobal
    {
        IDeploymentImporter _deploymentManager;
        static List<IUpdateManager> _managers;
        public static int AhobprRegistryId { get; set; }

        public static List<STD_FORM> FormLookup { get; set; }
        public static List<STD_FORM_SECTION> FormSectionLookup { get; set; }
        public static List<STD_FORM_SUB_SECTION> FormSubSectionLookup { get; set; }
        public static List<STD_FORM_QUESTION> FormQuestionLookup { get; set; }
        public static List<STD_FORM_ANSWER> FormAnswerLookup { get; set; }
        public static int AhobprUserRoleCareTeamId { get; set; }
        public static int AhobprUserRoleAdvancedUserId { get; set; }
        public static int AhobprUserRoleRegistryManagerId { get; set; }

        public const string AhobprRegistryCode = "AHOBPR";

        public const string AhobprJsonDataTypeInfo = "info";
        public const string AhobprJsonDataTypeUser = "user";
        public const string AhobprJsonDataTypeResponses = "responses";
        public const string AhobprJsonDataTypeForm = "form";
        public const string AhobprJsonDataTypeDeploymentLocations = "deploymentLocations";
        public const string AhobprUserRoleRegistryManagerCode = "AHOBPR_REGISTRY_MANAGER";
        public const string AhobprUserRoleAdvancedUserCode = "AHOBPR_ADVANCED_USER";
        public const string AhobprUserRoleCareTeamCode = "AHOBPR_CARE_TEAM";

        public const string AhobprJsonTypeUserForm = "user_form";
        public const string AhobprJsonTypeFormFollowup = "form_followup";
        public const string AhobprJsonTypeResponsesFollowup = "responses_followup";
        public const string AhobprJsonTypeMessage = "message";

        public const string AhobprJsonStatusNew = "New";
        public const string AhobprJsonStatusCompleted = "Completed";

        public const string AhobprFileTypeResponsePdf = "responsePdf";

        public const string AhobprQueueTypeEmail = "Email";
        public const string AhobprQueueTypeNotification = "Notification";
        public const string AhobprQueueTypeFollowupQuestions = "Follow-up Questions";
        public const string AhobprQueueTypeFlag = "Flag";
        public const string AhobprQueueTypeUserEmail = "User Email";

        public const string MessageFollowupQuestions = "New Follow-up Questions";

        public const int TimeOutForReports = 5000;

        public static string AhobprDefaultFormId
        {
            get
            {
                return WebConfigurationManager.AppSettings["AhobprDefaultFormId"];
            }
        }
        public static List<IUpdateManager> RegistrantManagers
        {
            get
            {
                if (_managers == null)
                {
                    _managers = new List<IUpdateManager> {
                                                               new RegistrantRetirementManager(),
                                                               new VeteranStatusManager(),
                                                               new MilitaryServiceEpisodeManager(),
                                                               new RegistrantDeploymentManager()
                                                            };

                }
                return _managers;
            }
        }
        public static string IntensiveLoggingFileName
        {
            get
            {
                try
                {
                    return WebConfigurationManager.AppSettings["IntensiveLoggingFileName"];
                }
                catch (Exception ex)
                {
                    AHOBPRLogger.LogErrorMessage("Exception: " + ex.Message, "AHOBPRGlobal." + MethodBase.GetCurrentMethod().Name, ex.StackTrace);
                }
                return null;
            }
        }
        public IDeploymentImporter DoDImporter
        {
            get
            {
                if (_deploymentManager == null) { CreateDoDImporter(); }
                return _deploymentManager;
            }
        }
        private void CreateDoDImporter()
        {

            string importerClassName = WebConfigurationManager.AppSettings["DeploymentImporterClass"].ToString();
            var assembly = Assembly.GetAssembly(typeof(AHOBPRBaseBO));
            Type type = assembly.GetType(importerClassName);
            if (type == null)
                throw new NullReferenceException($"{importerClassName} not found in assembly '{assembly.FullName}'. Is the class name in the Web.Config setting 'DeploymentImporterClass' configured correctly?");
            try
            {
                _deploymentManager = Activator.CreateInstance(type) as IDeploymentImporter;
            }
            catch (Exception ex)
            {

                AHOBPRLogger.LogErrorMessage("Exception: " + ex.Message, "AHOBPRGlobal." + MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }

        }

    }
}